/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.client.screen.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.toma.gunsrpg.client.render.IOrderedRender;
import dev.toma.gunsrpg.util.ITickable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.INestedGuiEventHandler;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.StringTextComponent;

public class ContainerWidget
extends Widget
implements INestedGuiEventHandler,
ITickable {
    private final List<IGuiEventListener> listeners = new ArrayList<IGuiEventListener>();
    private final List<Widget> widgets = new ArrayList<Widget>();
    private final List<ITickable> tickables = new ArrayList<ITickable>();
    private IGuiEventListener focused;
    private boolean dragging;

    public ContainerWidget(int x, int y, int width, int height) {
        super(x, y, width, height, StringTextComponent.field_240750_d_);
    }

    public <L extends IGuiEventListener> L addGuiEventListener(L listener) {
        this.listeners.add(listener);
        if (listener instanceof ITickable) {
            this.tickables.add((ITickable)listener);
        }
        return listener;
    }

    public void removeGuiEventListener(IGuiEventListener listener) {
        this.listeners.remove(listener);
        if (listener instanceof ITickable) {
            this.tickables.remove(listener);
        }
    }

    public <W extends Widget> W addWidget(W widget) {
        this.widgets.add(widget);
        return this.addGuiEventListener((IGuiEventListener)widget);
    }

    public void removeWidget(Widget widget) {
        this.widgets.remove(widget);
        this.removeGuiEventListener((IGuiEventListener)widget);
    }

    public void clear() {
        this.listeners.clear();
        this.widgets.clear();
        this.focused = null;
    }

    public void sortRenderOrder() {
        this.widgets.sort(ContainerWidget::compareWidgets);
    }

    @Override
    public void tick() {
        this.tickables.forEach(ITickable::tick);
    }

    public Stream<Widget> childrenAsStream() {
        return this.widgets.stream();
    }

    public void func_230431_b_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.widgets.forEach(widget -> widget.func_230430_a_(stack, mouseX, mouseY, partialTicks));
    }

    public boolean func_231044_a_(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        return super.func_231044_a_(p_231044_1_, p_231044_3_, p_231044_5_);
    }

    public boolean func_231048_c_(double p_231048_1_, double p_231048_3_, int p_231048_5_) {
        return super.func_231048_c_(p_231048_1_, p_231048_3_, p_231048_5_);
    }

    public boolean func_231045_a_(double p_231045_1_, double p_231045_3_, int p_231045_5_, double p_231045_6_, double p_231045_8_) {
        return super.func_231045_a_(p_231045_1_, p_231045_3_, p_231045_5_, p_231045_6_, p_231045_8_);
    }

    public boolean func_231043_a_(double p_231043_1_, double p_231043_3_, double p_231043_5_) {
        return super.func_231043_a_(p_231043_1_, p_231043_3_, p_231043_5_);
    }

    public void func_212927_b(double p_212927_1_, double p_212927_3_) {
        super.func_212927_b(p_212927_1_, p_212927_3_);
    }

    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        return super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_);
    }

    public boolean func_223281_a_(int p_223281_1_, int p_223281_2_, int p_223281_3_) {
        return super.func_223281_a_(p_223281_1_, p_223281_2_, p_223281_3_);
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.listeners;
    }

    public boolean func_231041_ay__() {
        return this.dragging;
    }

    public void func_231037_b__(boolean dragging) {
        this.dragging = dragging;
    }

    public IGuiEventListener func_241217_q_() {
        return this.focused;
    }

    public void func_231035_a_(IGuiEventListener focused) {
        this.focused = focused;
    }

    public static int compareWidgets(Widget w1, Widget w2) {
        int v1 = w1 instanceof IOrderedRender ? ((IOrderedRender)w1).getRenderIndex() : 0;
        int v2 = w2 instanceof IOrderedRender ? ((IOrderedRender)w2).getRenderIndex() : 0;
        return v1 - v2;
    }
}

